<?php
/**
 * Get Current User Profile
 * GET /api/user/me
 */

require_once '../../config/config.php';
require_once '../../config/database.php';
require_once '../../config/jwt.php';

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    error('Method not allowed', 'METHOD_NOT_ALLOWED', 405);
}

try {
    $user_id = getCurrentUser();
    
    $db = new Database();
    $conn = $db->getConnection();
    
    // Get user details
    $stmt = $conn->prepare("
        SELECT u.id, u.username, u.email, u.phone, u.referral_code, u.referred_by, u.created_at,
               w.main_balance, w.bonus_balance
        FROM users u
        LEFT JOIN wallets w ON u.id = w.user_id
        WHERE u.id = ? AND u.is_active = 1
    ");
    $stmt->execute([$user_id]);
    $user = $stmt->fetch();
    
    if (!$user) {
        error('User not found', 'USER_NOT_FOUND', 404);
    }
    
    // Get referral stats
    $stmt = $conn->prepare("
        SELECT COUNT(*) as total_referrals, SUM(bonus_amount) as total_bonus
        FROM referrals 
        WHERE referrer_id = ?
    ");
    $stmt->execute([$user_id]);
    $referral_stats = $stmt->fetch();
    
    // Get game stats
    $stmt = $conn->prepare("
        SELECT 
            COUNT(*) as total_games,
            SUM(CASE WHEN winner_id = ? THEN 1 ELSE 0 END) as games_won,
            SUM(CASE WHEN winner_id IS NULL AND status = 'completed' THEN 1 ELSE 0 END) as games_drawn
        FROM games 
        WHERE (player1_id = ? OR player2_id = ?) AND status = 'completed'
    ");
    $stmt->execute([$user_id, $user_id, $user_id]);
    $game_stats = $stmt->fetch();
    
    success([
        'user' => [
            'id' => $user['id'],
            'username' => $user['username'],
            'email' => $user['email'],
            'phone' => $user['phone'],
            'referral_code' => $user['referral_code'],
            'referred_by' => $user['referred_by'],
            'created_at' => $user['created_at'],
            'wallet' => [
                'main_balance' => $user['main_balance'],
                'bonus_balance' => $user['bonus_balance']
            ],
            'referral_stats' => [
                'total_referrals' => $referral_stats['total_referrals'],
                'total_bonus' => $referral_stats['total_bonus']
            ],
            'game_stats' => [
                'total_games' => $game_stats['total_games'],
                'games_won' => $game_stats['games_won'],
                'games_drawn' => $game_stats['games_drawn'],
                'win_rate' => $game_stats['total_games'] > 0 ? 
                    round(($game_stats['games_won'] / $game_stats['total_games']) * 100, 2) : 0
            ]
        ]
    ]);
    
} catch (Exception $e) {
    error_log("Get user error: " . $e->getMessage());
    error('Failed to get user data', 'USER_ERROR', 500);
}
?>
